* arcsine.sas;
title 'One-way ANOVA for proportions';
data arcsine;
	input predators survivors;
	prop = survivors/20;
	* Apply transformations here;
	y = arsin(sqrt(prop));
	datalines;
0 18
0 18
0 18
0 16
0 19
0 19
0 17
0 18
0 20
0 17
1 14
1 17
1 15
1 10
1 17
1 14
1 13
1 17
1 14
1 15
2 12
2 16
2 16
2 12
2 6
2 12
2 13
2 10
2 9
2 10
;
run;
* Print data set;
proc print data=arcsine;
run;
* Plot means, standard errors, and observations;
proc gplot data=arcsine;
	plot y*predators=1 / vaxis=axis1 haxis=axis1;
	symbol1 i=std1mjt v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* One-way anova with all fixed effects;
proc glm plots=diagnostics data=arcsine;
	class predators;
	model y = predators;
run;
quit;
